/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.features.chunk_rendering;

import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import me.jellysquid.mods.sodium.client.util.ExtChunkProviderClient;
import me.jellysquid.mods.sodium.client.util.math.MathChunkPos;
import me.jellysquid.mods.sodium.client.world.ChunkStatusListener;
import me.jellysquid.mods.sodium.client.world.ChunkStatusListenerManager;
import net.minecraft.client.multiplayer.ChunkProviderClient;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.Chunk;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChunkProviderClient.class})
public abstract class MixinClientChunkManager
implements ChunkStatusListenerManager,
ExtChunkProviderClient {
    private final LongOpenHashSet loadedChunks = new LongOpenHashSet();
    private boolean needsTrackingUpdate = false;
    private ChunkStatusListener listener;

    @Shadow
    public abstract Chunk func_186025_d(int var1, int var2);

    @Inject(method={"loadChunk"}, at={@At(value="RETURN")})
    private void afterLoadChunkFromPacket(int x, int z, CallbackInfoReturnable<Chunk> cir) {
        if (this.listener != null) {
            this.listener.onChunkAdded(x, z);
            this.loadedChunks.add(ChunkPos.func_77272_a((int)x, (int)z));
        }
    }

    @Inject(method={"unloadChunk"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/chunk/Chunk;onUnload()V", shift=At.Shift.AFTER)})
    private void afterUnloadChunk(int x, int z, CallbackInfo ci) {
        if (this.listener != null) {
            this.listener.onChunkRemoved(x, z);
            this.loadedChunks.remove(ChunkPos.func_77272_a((int)x, (int)z));
        }
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    private void afterTick(CallbackInfoReturnable<Boolean> cir) {
        if (!this.needsTrackingUpdate) {
            return;
        }
        LongIterator it = this.loadedChunks.iterator();
        while (it.hasNext()) {
            int z;
            long pos = it.nextLong();
            int x = MathChunkPos.getX(pos);
            if (this.func_186025_d(x, z = MathChunkPos.getZ(pos)) != null) continue;
            it.remove();
            if (this.listener == null) continue;
            this.listener.onChunkRemoved(x, z);
        }
        this.needsTrackingUpdate = false;
    }

    @Override
    public void setNeedsTrackingUpdate(boolean needsTrackingUpdate) {
        this.needsTrackingUpdate = needsTrackingUpdate;
    }

    @Override
    public boolean needsTrackingUpdate() {
        return this.needsTrackingUpdate;
    }

    @Override
    public void setListener(ChunkStatusListener listener) {
        this.listener = listener;
    }
}

